(*| 17:25 10/01/1990 *)
PROGRAM ARCCAT;

USES Dos;

CONST
  PAKSize =29;

TYPE
  FNameType= STRING[12];
  LineString= STRING[80];
  ADClass=(ByteClass,StrucClass);
  ArcDirType= RECORD
                CASE ADClass OF
                  ByteClass:(ADByte     : ARRAY[0..PAKSize-1] OF Byte);
                  StrucClass:(ADEOF     : Byte;
                              ADStyle   : Byte;
                              ADName    : ARRAY[1..13] OF Char;
                              ADSizeNow : LongInt;
                              ADDate    : Word;
                              ADTime    : Word;
                              ADCrc     : Word;
                              ADSize    : LongInt);
              END;

VAR
  FileName:FNameType;

FUNCTION IntToString(Num, Width : Integer) : LineString;
{ Changes an integer into a string }
VAR TempString : LineString;
BEGIN
  Str(Num:Width, TempString);
  IntToString := TempString;
END; { IntToString }

FUNCTION IntToPadString(Num, Width : Integer) : LineString;
{ Changes an integer into a string and pads it with a zero on the left if
  it is less than 10 }
BEGIN
  IF Num < 10 THEN
    IntToPadString := '0' + IntToString(Num, Width)
  ELSE
    IntToPadString := IntToString(Num, Width);
END; { IntToString }

FUNCTION FileDateString(DateInt :LongInt):LineString;
VAR Date:DateTime;
BEGIN
  UnpackTime(DateInt,Date);
  WITH Date DO
    FileDateString:=IntToString(Day,2) + '/' +
                    IntToPadString(Month,1) + '/' +
                    IntToString(Year MOD 100,2);
END;  { FileDateString }

FUNCTION FileTimeString(TimeInt :LongInt):LineString;
VAR Time:DateTime;
BEGIN
  UnpackTime(TimeInt,Time);
  WITH Time DO
    FileTimeString:=IntToString(Hour,2) + ':' +
                    IntToPadString(Min,1) + ':' +
                    IntToPadString(Sec,1);
END; { FileTimeString }

PROCEDURE WriteHex(N,Size: Integer);

Var
  I,J,K,Mask: Integer;

BEGIN
  J:=(Size-1)*4;
  Mask:=15 SHL J;
  FOR I:=1 TO Size DO
    BEGIN
      K:=(N AND Mask) SHR J;
      IF K > 9 THEN Write(Chr(K+55)) ELSE Write(K);
      Mask:=Mask SHR 4;
      J:=J-4;
    END;
  Write(' ');
END;

PROCEDURE ShowArcDir(ArcName: FNameType);
VAR
  ArcFile: FILE OF Byte;
  FilePos,TotSize,TotSizeNow,TotFiles: LongInt;
  ArcDir:ArcDirType;

FUNCTION NextByte: Byte;
VAR NB:Byte;
BEGIN
  Read(ArcFile,NB);
  NextByte:=NB;
END;

FUNCTION NextWord: Word;
VAR NW:Word;
BEGIN
  NW:=NextByte;
  NextWord:=NW+(NextByte SHL 8);
END;

FUNCTION NextLongInt: LongInt;
VAR NLI:LongInt;
BEGIN
  NLI:=NextWord;
  NextLongInt:=NLI+(LongInt(NextWord) SHL 16);
END;

PROCEDURE ShowInfo(ArcDir:ArcDirType);
VAR
  DT:LongInt;
  I:Integer;
  ThisName:FNameType;
BEGIN
  WITH ArcDir DO BEGIN
    ThisName:='';
    I:=0;
    REPEAT
      INC(I);
      IF ADName[I] <> #0 THEN
        ThisName:=ThisName+ADName[I];
    UNTIL ADName[I] = #0;
    DT:=LongInt(ADDate) SHL 16;
    DT:=DT+ADTime;
    Write(ThisName:12,' ',ADSize:7,' ',ADStyle,' ',ADSizeNow:6,
                      ' ',100-((ADSizeNow*100) DIV ADSize):3,'%',
                      ' ',FileDateString(DT),
                      ' ',FileTimeString(DT),' ');
    WriteHex(ADCrc,4);
    Writeln;
  END;
END;

PROCEDURE NextEntry(VAR ArcDir:ArcDirType);
VAR
  B:Byte;
  I:Integer;
  W:Word;
BEGIN
  WITH ArcDir DO BEGIN
    ADStyle:=0;
    Seek(ArcFile,FilePos);
    ADByte[0]:=NextByte;
    IF ADEOF = $1A THEN BEGIN
      ADByte[1]:=NextByte;
      IF ADStyle <> 0 THEN BEGIN
        FOR I:=2 TO PAKSize-1 DO
          ADByte[I]:=NextByte;
        FilePos:=FilePos+ADSizeNow+PAKSize;
        INC(TotFiles);
        TotSizeNow:=TotSizeNow+ADSizeNow;
        TotSize:=TotSize+ADSize;
      END;
    END;
  END;
END;

BEGIN
  ASSIGN(ArcFile,ArcName);
{$I-}
  RESET(ArcFile);
{$I+}
  IF IOResult<>0 THEN
    Writeln('Unable to open ',ArcName)
  ELSE WITH ArcDir DO BEGIN
    Writeln('FileName','Length':12,'Size':8,'Ratio':7,
               'Date':7,'Time':8,'CRC':6);
    Writeln;
    FilePos:=0;
    TotFiles:=0;
    TotSize:=0;
    TotSizeNow:=0;
    REPEAT
      NextEntry(ArcDir);
      IF ADStyle <> 0 THEN
        ShowInfo(ArcDir);
    UNTIL ADStyle=0;
    Writeln('----','------':16,'------':9,'----':5);
    Writeln(TotFiles:4,TotSize:16,TotSizeNow:9,
            100-((TotSizeNow*100) DIV TotSize):4,'%');
    Close(ArcFile);
  END;
END;  { ShowArcDir }

PROCEDURE SetFileName;
BEGIN
  IF ParamCount > 0 THEN
    FileName:=ParamStr(1)
  ELSE BEGIN
    Write('Name of ARC file : ');
    Readln(FileName);
  END;
  IF POS('.',FileName)=0 THEN
    FileName:=FileName+'.ARC';
END;  { SetFileName }

BEGIN
  Writeln('Arc Directory Program by B Whitnall, V1.0');
  Writeln;
  SetFileName;
  Writeln(FileName);
  Writeln;
  ShowArcDir(FileName);
END.
